 param(
  [string]$Host = '127.0.0.1',
  [int]$Port = 8000
)
Write-Host "[EKJ] 开始一键部署" -ForegroundColor Green
try { & php -v > $null 2>&1 } catch { Write-Error "未检测到 PHP，请安装后重试"; exit 1 }
$res = & php activation/deploy.php
Write-Host $res
if ($LASTEXITCODE -ne 0) { Write-Error "部署失败"; exit $LASTEXITCODE }
Write-Host "[EKJ] 启动内置服务器 http://$Host:$Port/" -ForegroundColor Green
Start-Process -NoNewWindow -FilePath "php" -ArgumentList "-S $Host`:$Port -t activation" | Out-Null
Start-Sleep -Milliseconds 800
Write-Host "首页: http://$Host:$Port/activation/home.php" -ForegroundColor Yellow
Write-Host "后台: http://$Host:$Port/activation/admin/" -ForegroundColor Yellow