
ekj_boot();


function removeElement(element) {
    if (element && element.parentNode) {
        element.parentNode.removeChild(element);
    }
}
// === Activation helpers and bootstrap ===
// Default verify API endpoint (update to your domain)
const EKJ_VERIFY_URL_DEFAULT = 'https://cj.ekj123.com/api/verify.php';

function ekjStorageGet(keys) {
    return new Promise((resolve) => {
        try {
            if (typeof chrome !== 'undefined' && chrome.storage && chrome.storage.local) {
                chrome.storage.local.get(keys, resolve);
            } else {
                const out = {};
                if (Array.isArray(keys)) {
                    keys.forEach(k => out[k] = JSON.parse(localStorage.getItem(k) || 'null'));
                } else if (typeof keys === 'string') {
                    out[keys] = JSON.parse(localStorage.getItem(keys) || 'null');
                } else if (typeof keys === 'object' && keys !== null) {
                    Object.keys(keys).forEach(k => out[k] = JSON.parse(localStorage.getItem(k) || 'null'));
                }
                resolve(out);
            }
        } catch (e) { resolve({}); }
    });
}

function ekjStorageSet(obj) {
    return new Promise((resolve) => {
        try {
            if (typeof chrome !== 'undefined' && chrome.storage && chrome.storage.local) {
                chrome.storage.local.set(obj, resolve);
            } else {
                Object.keys(obj || {}).forEach(k => localStorage.setItem(k, JSON.stringify(obj[k])));
                resolve();
            }
        } catch (e) { resolve(); }
    });
}

async function ekjGetVerifyUrl() {
    const { ekj_verify_url } = await ekjStorageGet(['ekj_verify_url']);
    let url = ekj_verify_url || EKJ_VERIFY_URL_DEFAULT;
    try {
        // Auto-upgrade to HTTPS for cj.ekj123.com
        const u = new URL(url);
        if (u.hostname === 'cj.ekj123.com') {
            if (u.protocol === 'http:') u.protocol = 'https:';
            url = u.toString();
            await ekjStorageSet({ ekj_verify_url: url });
        }
    } catch (e) {}
    return url;
}

async function ekjGetDeviceId() {
    const { ekj_device_id } = await ekjStorageGet(['ekj_device_id']);
    if (ekj_device_id) return ekj_device_id;
    const rnd = 'ekj-' + Math.random().toString(36).slice(2, 10) + '-' + Date.now().toString(36);
    await ekjStorageSet({ ekj_device_id: rnd });
    return rnd;
}

function createActivationUI(onSubmit) {
    const box = document.createElement('div');
    box.className = 'ekj-activation-box';
    Object.assign(box.style, {
        position: 'fixed', top: '20px', right: '20px', zIndex: 2147483647,
        background: '#fff', border: '1px solid #e5e5e5', borderRadius: '10px',
        boxShadow: '0 8px 24px rgba(0,0,0,0.12)', padding: '12px',
        fontFamily: 'system-ui, -apple-system, Segoe UI, Roboto, Helvetica, Arial, sans-serif'
    });
    const title = document.createElement('div');
    title.textContent = '请输入激活码';
    Object.assign(title.style, { marginBottom: '8px', fontWeight: '600', color: '#333', fontSize: '14px' });
    const input = document.createElement('input');
    input.placeholder = 'EKJ-XXXX-XXXX-XXXX-XXXX';
    input.autocomplete = 'one-time-code';
    Object.assign(input.style, { border: '1px solid #d9d9d9', padding: '6px 8px', minWidth: '260px', borderRadius: '6px' });
    const btn = document.createElement('button');
    btn.textContent = '激活';
    Object.assign(btn.style, { marginLeft: '8px', padding: '8px 14px', borderRadius: '9999px', background: '#ff4d4f', color: '#fff', border: '1px solid #ff4d4f', cursor: 'pointer' });
    styleCapsuleButton(btn);
    const msg = document.createElement('div');
    Object.assign(msg.style, { marginTop: '6px', color: '#666', fontSize: '12px' });
    btn.addEventListener('click', () => onSubmit(input.value.trim(), msg));
    input.addEventListener('keydown', (e) => { if (e.key === 'Enter') btn.click(); });
    box.appendChild(title); box.appendChild(input); box.appendChild(btn); box.appendChild(msg);
    document.body.appendChild(box);
    return { box, input, btn, msg };
}

function isTikTokHost() {
    try { return typeof location !== 'undefined' && /(^|\.)tiktok\.com$/i.test(location.hostname); } catch (e) { return false; }
}

function isAliHost() {
    try { 
        return typeof location !== 'undefined' && /(^|\.)aliexpress\.com$/i.test(location.hostname);
    } catch (e) { return false; }
}

function isAliStoreItemsPage() {
    try {
        if (typeof location === 'undefined') return false;
        // 只在店铺商品列表页启用采集功能
        return /(^|\.)aliexpress\.com$/i.test(location.hostname) && 
               /\/store\/\d+\/pages\/all-items\.html/i.test(location.pathname);
    } catch (e) { return false; }
}

async function ensureActivated() {
    // 在任何AliExpress或TikTok页面都检查激活状态
    if (!isAliHost() && !isTikTokHost()) { window.__ekj_activated = true; return true; }
    try {
    const { ekj_activation } = await ekjStorageGet(['ekj_activation']);
        if (ekj_activation && (ekj_activation.ok === true || ekj_activation.status === 'ok' || ekj_activation.status === 'activated')) {
            window.__ekj_activated = true;
            return true;
        }
        return await new Promise(async (resolve) => {
            const deviceId = await ekjGetDeviceId();
            const url = await ekjGetVerifyUrl();
            const ui = createActivationUI(async (code, msgEl) => {
                if (!code) { msgEl.textContent = '请输入激活码'; return; }
                msgEl.textContent = '验证中...';
                try {
                    const data = await (async () => {
                        try {
                            // 添加超时控制
                            const controller = new AbortController();
                            const timeoutId = setTimeout(() => controller.abort(), 15000); // 15秒超时
                            
                            const res1 = await fetch(url, { 
                                method: 'POST', 
                                headers: { 'Content-Type': 'application/json' }, 
                                body: JSON.stringify({ code, device_id: deviceId }),
                                signal: controller.signal
                            });
                            
                            clearTimeout(timeoutId);
                            
                            // 404/500 fallback
                            if (!res1.ok) {
                                console.error('Primary API failed:', res1.status, res1.statusText);
                                throw new Error('primary_failed_' + res1.status);
                            }
                            return await res1.json();
                        } catch (e) {
                            console.error('Primary API error:', e);
                            clearTimeout(timeoutId);
                            // Try fallback path under /admin if primary fails
                            try {
                                const u = new URL(url);
                                u.pathname = '/activation/api/verify.php';
                                
                                // 添加超时控制
                                const controller2 = new AbortController();
                                const timeoutId2 = setTimeout(() => controller2.abort(), 15000); // 15秒超时
                                
                                const res2 = await fetch(u.toString(), { 
                                    method: 'POST', 
                                    headers: { 'Content-Type': 'application/json' }, 
                                    body: JSON.stringify({ code, device_id: deviceId }),
                                    signal: controller2.signal
                                });
                                
                                clearTimeout(timeoutId2);
                                
                                if (!res2.ok) {
                                    console.error('Fallback API failed:', res2.status, res2.statusText);
                                    throw new Error('fallback_failed_' + res2.status);
                                }
                                // Persist discovered fallback for next time
                                await ekjStorageSet({ ekj_verify_url: u.toString() });
                                return await res2.json();
                            } catch (e2) {
                                console.error('Fallback API error:', e2);
                                clearTimeout(timeoutId2);
                                throw e2;
                            }
                        }
                    })();
                    if (data && data.ok) {
                        await ekjStorageSet({ ekj_activation: data, ekj_activation_code: code });
                        ui.box.remove();
                        window.__ekj_activated = true;
                        resolve(true);
                    } else {
                        msgEl.textContent = (data && data.message) ? ('激活失败：' + data.message) : '激活失败';
                        resolve(false);
                    }
                } catch (e) {
                    console.error('Activation network error:', e);
                    if (e.name === 'AbortError') {
                        msgEl.textContent = '网络超时，请检查网络连接';
                    } else if (e.message.includes('primary_failed') || e.message.includes('fallback_failed')) {
                        msgEl.textContent = '服务器错误，请稍后重试(' + e.message + ')';
                    } else {
                        msgEl.textContent = '网络错误，请稍后重试';
                    }
                    resolve(false);
                }
            });
            setTimeout(() => ui.input.focus(), 0);
        });
    } catch (e) {
        console.error('Activation check error:', e);
        return false;
    }
}

function startTikTokFeatures() {
    try {
        // 检查是否在TikTok页面
        if (!isTikTokHost()) return;
        
        // 添加保存Cookie按钮
        addSaveCookieButton();
        
        console.log('TikTok功能已初始化');
    } catch (e) {
        console.error('TikTok功能初始化错误:', e);
    }
}

function addSaveCookieButton() {
    // 检查是否已添加按钮
    if (document.querySelector('.ekj-save-cookie-btn')) return;
    
    // 创建保存Cookie按钮
    const saveCookieBtn = document.createElement('button');
    saveCookieBtn.textContent = '保存Cookie';
    saveCookieBtn.className = 'ekj-save-cookie-btn';
    
    // 设置按钮样式
    Object.assign(saveCookieBtn.style, {
        position: 'fixed',
        top: '20px',
        right: '20px',
        zIndex: 2147483647,
        padding: '10px 15px',
        backgroundColor: '#ff4d4f',
        color: 'white',
        border: 'none',
        borderRadius: '5px',
        cursor: 'pointer',
        fontWeight: 'bold',
        boxShadow: '0 2px 5px rgba(0,0,0,0.2)'
    });
    
    // 添加点击事件
    saveCookieBtn.addEventListener('click', saveCookies);
    
    // 添加到页面
    document.body.appendChild(saveCookieBtn);
    
    // 添加悬停效果
    saveCookieBtn.addEventListener('mouseenter', () => {
        saveCookieBtn.style.backgroundColor = '#e64547';
    });
    
    saveCookieBtn.addEventListener('mouseleave', () => {
        saveCookieBtn.style.backgroundColor = '#ff4d4f';
    });
}

function saveCookies() {
    // 检查是否在TikTok页面
    if (!isTikTokHost()) {
        message('当前页面不是TikTok，无法保存Cookie');
        return;
    }
    
    try {
        // 获取所有Cookie
        const cookies = document.cookie;
        
        if (!cookies || cookies.trim() === '') {
            message('未找到Cookie，请确保已登录TikTok');
            return;
        }
        
        // 保存Cookie到扩展存储
        ekjStorageSet({ 'tiktok_cookies': cookies })
            .then(() => {
                message('Cookie保存成功！');
                console.log('TikTok Cookie已保存:', cookies);
            })
            .catch(error => {
                message('Cookie保存失败: ' + error.message);
                console.error('保存TikTok Cookie失败:', error);
            });
            
    } catch (error) {
        message('保存Cookie时出错: ' + error.message);
        console.error('保存TikTok Cookie出错:', error);
    }
}

function startAliFeatures() {
    try {
        // 只在店铺商品列表页启用采集功能
        if (!isAliStoreItemsPage()) return;
        if (!window.__ekj_auto_inited) {
            let tries = 0;
            const MAX_TRIES = 60;
            const checkAndInit = () => {
                if (window.__ekj_auto_inited) return;
                if (!window.__ekj_activated) { if (++tries < MAX_TRIES) return setTimeout(checkAndInit, 1000); else return; }
                const hasBody = !!document.body;
                const hasImgs = document.querySelector('a>div>div>img');
                if (hasBody) {
                    window.__ekj_auto_inited = true;
                    try { makeImage(); } catch (e) { console.error(e); }
                    return;
                }
                if (++tries < MAX_TRIES) setTimeout(checkAndInit, 1000);
            };
            setTimeout(checkAndInit, 0);
        }
        if (!window.__ekj_observer_attached) {
            try {
                const debouncedMakeImage = () => {
                    clearTimeout(window.__ekj_observeTimer);
                    window.__ekj_observeTimer = setTimeout(() => {
                        if (!window.__ekj_activated) return;
                        try { makeImage(); } catch (e) { console.error(e); }
                    }, 500);
                };
                const observer = new MutationObserver((mutations) => {
                    for (const m of mutations) {
                        if (m.addedNodes && m.addedNodes.length) { debouncedMakeImage(); break; }
                        if (m.type === 'attributes') { debouncedMakeImage(); break; }
                    }
                });
                observer.observe(document.body, { childList: true, subtree: true, attributes: false });
                window.__ekj_observer_attached = true;
                const wrapHistory = (type) => {
                    const orig = history[type];
                    if (typeof orig === 'function') {
                        history[type] = function () {
                            const ret = orig.apply(this, arguments);
                            debouncedMakeImage();
                            return ret;
                        };
                    }
                };
                wrapHistory('pushState');
                wrapHistory('replaceState');
                window.addEventListener('popstate', debouncedMakeImage);
            } catch (e) { console.error('Observer init error:', e); }
        }
    } catch (e) { console.error('Auto init error:', e); }
}

function ekj_boot(){
    if (!isAliHost() && !isTikTokHost()) return; // only run on AliExpress or TikTok
    ensureActivated().then(ok => { 
        if (ok) {
            if (isAliHost()) {
                startAliFeatures();
            } else if (isTikTokHost()) {
                startTikTokFeatures();
            }
        }
    });
}

// 胶囊按钮交互效果（hover/active）
function styleCapsuleButton(el) {
    if (!el || !el.style) return;
    el.style.transition = 'background-color .15s ease, box-shadow .15s ease, transform .05s ease, border-color .15s ease';
    const baseBg = '#ff4d4f';
    const hoverBg = '#e64547';
    const activeBg = '#c92f33';
    const setBase = () => {
        el.style.backgroundColor = baseBg;
        el.style.borderColor = baseBg;
        el.style.color = '#ffffff';
        el.style.boxShadow = '0 2px 4px rgba(0,0,0,0.1)';
        el.style.transform = 'translateY(0)';
    };
    const setHover = () => {
        el.style.backgroundColor = hoverBg;
        el.style.borderColor = hoverBg;
        el.style.boxShadow = '0 4px 8px rgba(0,0,0,0.15)';
        el.style.transform = 'translateY(-1px)';
    };
    const setActive = () => {
        el.style.backgroundColor = activeBg;
        el.style.borderColor = activeBg;
        el.style.boxShadow = '0 1px 2px rgba(0,0,0,0.12)';
        el.style.transform = 'translateY(0)';
    };
    setBase();
    el.addEventListener('mouseenter', setHover);
    el.addEventListener('mouseleave', setBase);
    el.addEventListener('mousedown', setActive);
    el.addEventListener('mouseup', () => {
        if (el.matches(':hover')) setHover(); else setBase();
    });
}
function createTreeSelect(data) {
    const select = document.createElement('select');
    select.style.width = "100%";

    select.classList.add('my-select');
    function buildOption(item, prefix = '') {
        const option = document.createElement('option');
        option.value = item.id;
        option.textContent = prefix + item.name;
        return option;
    }

    function buildTree(items, parentId, prefix = '') {
        const options = [];
        items.forEach(item => {
            if (item.pid == parentId) {
                options.push(buildOption(item, prefix));
                const childrenOptions = buildTree(items, item.id, prefix + '--');
                options.push(...childrenOptions);
            }
        });
        return options;
    }

    // 构建选项数组
    const optionsToAppend = buildTree(data, 0);

    // 添加选项到select元素
    optionsToAppend.forEach(option => {
        select.appendChild(option);
    });

    // 将select元素添加到页面
    // document.body.appendChild(select);
    return select;
}


function canonicalAliLink(href) {
    try {
        const u = new URL(href, (typeof location !== 'undefined' ? location.origin : 'https://www.aliexpress.com'));
        const m1 = u.pathname.match(/\/(?:item|i)\/(\d+)\.html/i);
        let pid = m1 && m1[1];
        if (!pid) {
            const m2 = (u.search || '').match(/(?:product_id|id|gid)=(\d+)/i);
            pid = m2 && m2[1];
        }
        if (pid) return 'https://www.aliexpress.com/item/' + pid + '.html';
        u.search = '';
        u.hash = '';
        return u.origin + u.pathname;
    } catch (e) {
        const idx = (href || '').indexOf('?');
        return idx >= 0 ? href.substring(0, idx) : href;
    }
}

//一键采集
function send() {


    var all = document.createElement('div');

    var allStyles = {
        padding: '8px 16px',
        borderRadius: '9999px',
        display: 'inline-flex',
        alignItems: 'center',
        justifyContent: 'center',
        backgroundColor: '#ff4d4f',
        border: '1px solid #ff4d4f',
        cursor: 'pointer',
        color: '#ffffff',
        fontSize: '14px',
        lineHeight: '1',
        boxShadow: '0 2px 4px rgba(0,0,0,0.1)',
        userSelect: 'none',
        marginRight: '8px'
    };
    Object.assign(all.style, allStyles);
    all.setAttribute('data-name', '采集');
    all.classList.add('my-send');
    all.textContent = '采集';
    styleCapsuleButton(all);
    // 将按钮挂载到Price右侧
    const allParent = (function(){
        const existed = document.querySelector('.ekj-toolbar');
        if (existed) return existed;
        
        // 查找包含 Best Match、Orders、New、Price 的排序容器
        const sortContainer = Array.from(document.querySelectorAll('div')).find(div => {
            const text = div.textContent || '';
            const style = div.getAttribute('style') || '';
            return text.includes('Best Match') && 
                   text.includes('Orders') && 
                   text.includes('Price') &&
                   style.includes('display: flex') &&
                   style.includes('flex-direction: row');
        });
        
        if (sortContainer) {
            const box = document.createElement('div');
            box.className = 'ekj-toolbar';
            Object.assign(box.style, { 
                display: 'inline-flex', 
                gap: '8px', 
                alignItems: 'center'
            });
            sortContainer.appendChild(box);
            return box;
        }
        
        // 备用方案：创建固定定位的工具栏
        const box = document.createElement('div');
        box.className = 'ekj-toolbar';
        Object.assign(box.style, { 
            position: 'fixed',
            top: '80px',
            right: '20px',
            zIndex: '9999',
            display: 'flex', 
            gap: '8px', 
            alignItems: 'center',
            background: 'white',
            padding: '10px',
            borderRadius: '8px',
            boxShadow: '0 2px 8px rgba(0,0,0,0.15)'
        });
        (document.body || document.documentElement).appendChild(box);
        return box;
    })();

    if (document.querySelector('.my-send[data-name="采集"]') == null) {
        allParent.appendChild(all);
        all.addEventListener('click', function (event) {

            //const cate = document.querySelector('.my-select').value;
            var list = [];
            var uniqueLinks = new Set(); // 使用Set来存储唯一链接
            var duplicateCount = 0; // 记录重复链接数量

            var targetDiv = document.querySelectorAll('.my-label[data-type="2"]');
           
            var str = '';

            for (let index = 0; index < targetDiv.length; index++) {
                const element = targetDiv[index];
                var parentA = element.parentElement.parentElement.parentElement.parentElement.querySelector('a');
                const href = parentA ? parentA.href : null;
                
                if (href) {
                    const canon = canonicalAliLink(href);
                    if (!uniqueLinks.has(canon)) {
                        uniqueLinks.add(canon);
                        str = str + '' + canon + ' \n';
                        list.push(canon);
                    } else {
                        duplicateCount++;
                    }
                }
            }
            console.log('地址：', list);
            console.log('去重后的链接数量：', uniqueLinks.size);
            const textContent = str+'';
	console.log('txt：', str);
            
            // 显示采集结果提示
            let resultMessage = `✅ 成功采集 ${uniqueLinks.size} 个商品链接`;
            if (duplicateCount > 0) {
                resultMessage += `\n🔄 已自动去除 ${duplicateCount} 个重复链接`;
            }
            console.log(`总共发现 ${targetDiv.length} 个商品，去重后保留 ${uniqueLinks.size} 个`);
            message(resultMessage);

	const blob = new Blob([textContent], { type: "text/plain" });


	// 创建一个链接元素并设置其下载属性


	const link = document.createElement("a");


	link.href = URL.createObjectURL(blob);


// 生成基于日期时间的文件名
const now = new Date();
const year = now.getFullYear();
const month = String(now.getMonth() + 1).padStart(2, '0');
const day = String(now.getDate()).padStart(2, '0');
const hours = String(now.getHours()).padStart(2, '0');
const minutes = String(now.getMinutes()).padStart(2, '0');
const seconds = String(now.getSeconds()).padStart(2, '0');
const filename = `EKJ采集_${year}${month}${day}_${hours}${minutes}${seconds}.txt`;

link.download = filename;


	// 触发下载事件


	link.click();

            // const parentA = this.parentElement.parentElement.parentElement.parentElement.querySelector('a');
            // const href = parentA ? parentA.href : null;

        });
    }



}
function makeSelectAll() {

    var all = document.createElement('div');
    console.log('我运行了all：'+all);
    var allStyles = {
        padding: '8px 16px',
        borderRadius: '9999px',
        display: 'inline-flex',
        alignItems: 'center',
        justifyContent: 'center',
        backgroundColor: '#ff4d4f',
        border: '1px solid #ff4d4f',
        cursor: 'pointer',
        color: '#ffffff',
        fontSize: '14px',
        lineHeight: '1',
        boxShadow: '0 2px 4px rgba(0,0,0,0.1)',
        userSelect: 'none',
        marginRight: '8px'
    };

    Object.assign(all.style, allStyles);

    all.textContent = '全选';
    all.setAttribute('data-type', '1');
    all.setAttribute('data-name', '全选');
    all.classList.add('my-all');
    styleCapsuleButton(all);
    console.log('我添加了all：'+all);
   console.log('我运行了4444');
    //message('我运行了4444');
    // 将按钮挂载到Price右侧
    const allParent = (function(){
        const existed = document.querySelector('.ekj-toolbar');
        if (existed) return existed;
        
        // 查找包含 Best Match、Orders、New、Price 的排序容器
        const sortContainer = Array.from(document.querySelectorAll('div')).find(div => {
            const text = div.textContent || '';
            const style = div.getAttribute('style') || '';
            return text.includes('Best Match') && 
                   text.includes('Orders') && 
                   text.includes('Price') &&
                   style.includes('display: flex') &&
                   style.includes('flex-direction: row');
        });
        
        if (sortContainer) {
            const box = document.createElement('div');
            box.className = 'ekj-toolbar';
            Object.assign(box.style, { 
                display: 'inline-flex', 
                gap: '8px', 
                alignItems: 'center'
            });
            sortContainer.appendChild(box);
            return box;
        }
        
        // 备用方案：创建固定定位的工具栏
        const box = document.createElement('div');
        box.className = 'ekj-toolbar';
        Object.assign(box.style, { 
            position: 'fixed',
            top: '80px',
            right: '20px',
            zIndex: '9999',
            display: 'flex', 
            gap: '8px', 
            alignItems: 'center',
            background: 'white',
            padding: '10px',
            borderRadius: '8px',
            boxShadow: '0 2px 8px rgba(0,0,0,0.15)'
        });
        (document.body || document.documentElement).appendChild(box);
        return box;
    })();
    //const allParent = document.querySelector('#right > div:first-child > div:nth-child(2) > div:nth-child(1)');
    if (document.querySelector('.my-all[data-name="全选"]') == null) {
        console.log('我运行了5555');	
        allParent.appendChild(all);
        all.addEventListener('click', function (event) {
	
            var dataTypeValue = this.getAttribute('data-type');
            // console.log(dataTypeValue); // 输出 data-type 的值
            //quanxain
            if (dataTypeValue == 1) {
                const targetImages = document.querySelectorAll('.my-label');
                targetImages.forEach(img => {
                    img.style.backgroundColor = 'red';
                    img.style.color = 'white';
                    img.setAttribute('data-type', '2');
                });
                this.setAttribute('data-type', '2');
            }

            if (dataTypeValue == 2) {
                const targetImages = document.querySelectorAll('.my-label');
                targetImages.forEach(img => {
                    img.style.backgroundColor = 'white';
                    img.style.color = '#000';
                    img.setAttribute('data-type', '1');
                });
                this.setAttribute('data-type', '1');
            }


        });
    }


}
function makeImage() {
    //message('我运行了33333');
    console.log('我运行了33333');
    makeSelectAll();
    send();

    const inputEl = document.querySelector('.my-input');
    const inputValue = inputEl ? inputEl.value : '';
    var user = inputValue;
    removeElement(document.querySelector('.my-select'));

    const targetImages = document.querySelectorAll('a>div>div>img');
    targetImages.forEach(img => {
        const parent = img.parentElement;
        if (!parent) return;
        const card = img.closest('a');
        if (!card) return;
        const existingInCard = card.querySelector('.my-label');
        if (existingInCard) return;
        if (typeof getComputedStyle === 'function' && getComputedStyle(parent).position === 'static') parent.style.position = 'relative';
        const label = document.createElement('div');
        label.classList.add('my-label');
        label.style.position = 'absolute';
        label.style.bottom = '0';
        label.style.right = '0';
        label.style.backgroundColor = 'white';
        label.style.color = '#000';
        label.style.padding = '6px 42px';
        label.style.borderTopLeftRadius = '4px';
        label.style.opacity = .7;
        label.setAttribute('data-type', '1');
        label.textContent = '采集';
        parent.appendChild(label);
        // 添加点击事件
        // 添加点击事件并允许冒泡
        // 添加点击事件并阻止默认行为（跳转）
        label.addEventListener('click', function (event) {
            event.preventDefault();
            event.stopPropagation();
            var dataTypeValue = this.getAttribute('data-type');
            if (dataTypeValue == 1) {
                this.style.backgroundColor = 'red';
                this.style.color = 'white';
            } else {
                this.style.backgroundColor = 'white';
                this.style.color = '#000';
            }
            this.setAttribute('data-type', dataTypeValue == 1 ? 2 : 1);

            // const inputValue = document.querySelector('.my-input').value;
            // if (inputValue == '') {
            //     message('请在右边输入库填写秘钥');
            //     return false;
            // }
            // 创建一个临时的消息提示元素
            // message('正在提交采集');


            // const parentA = this.parentElement.parentElement.parentElement.parentElement.querySelector('a');
            // const href = parentA ? parentA.href : null;
            // const xhr = new XMLHttpRequest();
            // xhr.open('POST', 'https://kj.wukongzu.com/api/Collection/addCollect', true);
            // xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
            // xhr.send('href=' + encodeURIComponent(href) + '&value=' + inputValue);

            // xhr.onload = function () {
            //     console.log(xhr, 'xhr');
            //     var data = JSON.parse(xhr.response);
            //     console.log(data, 'data');
            //     console.log(data.msg, 'data.msg');
            //     if (xhr.status === 200) {
            //         message(data.msg);
            //     } else {
            //         message(data.msg);
            //     }
            // };
            // console.log('Label clicked and AJAX request sent with href!');
            // console.log('Label clicked!');
        });
    });



}

// 使用 fetch API 发送 GET 请求
function sendGetRequest(url, callback) {
    fetch(url)
        .then(response => {
            if (!response.ok) {
                throw new Error('Network response was not ok');
            }
            return response.json();
        })
        .then(data => {
            callback(data);
        })
        .catch(error => {
            callback(null, error);
        });
}

// 调用函数，假设你想要请求的URL是 'https://api.example.com/data'
function input() {
     //message('我运行了'); 
     console.log('我运行了');
    // var data = [
    //     { id: '1', pid: 0, name: '食品' },
    //     { id: '2', pid: 1, name: '面包' },
    //     { id: '10', pid: 2, name: '面包2' },
    //     { id: '3', pid: 1, name: '蛋糕' },
    //     { id: '4', pid: 1, name: '饼干' },
    //     { id: '5', pid: 0, name: '水果' },
    //     { id: '6', pid: 5, name: '苹果' },
    //     { id: '7', pid: 5, name: '香蕉' },
    //     { id: '8', pid: 5, name: '橙子' },
    //     { id: '9', pid: 0, name: '饮料' },
    //     { id: '10', pid: 9, name: '可乐' },
    //     { id: '11', pid: 9, name: '果汁' },
    //     { id: '12', pid: 9, name: '茶' }
    // ];
    // 输入框容器
    // console.log(document.querySelector('body'));
    // 创建输入框和确定按钮
    const input = document.createElement('input');
    input.classList.add('my-input');
    input.style.border = '1px solid #000';
    input.style.margin = '5px';
    input.style.padding = '5px';
    const button = document.createElement('button');
    button.textContent = '初始化采集';
    // 隐藏手动“初始化”按钮（改为自动初始化）
    button.style.display = 'none';
    const container = document.createElement('div');
    container.style.position = 'fixed';
    container.classList.add('my-container');
    container.style.top = '50%';
    container.style.right = 0; // 调整位置使其在页面右中间
    container.style.transform = 'translateY(-50%)';
    container.style.backgroundColor = '#fff';
    container.style.padding = '10px';
    container.style.border = '1px solid #ccc';
    container.style.boxShadow = '0 0 5px rgba(0,0,0,0.3)';
    container.style.zIndex = 999;
    container.style.opacity = .5;
    // console.log(container,'container');
    // 创建标题并加粗
    const title = document.createElement('div');
    title.style.fontWeight = 'bold';
    title.style.fontSize = '16px';
    title.style.textAlign = 'left';
    title.style.margin = '5px';
    var user = '';
    // const inputValue = document.querySelector('.my-input').value;
    // if (inputValue == '') {
    //     message('请在右边输入库填写秘钥');
    //     return false;
    // }
    // var user = inputValue;
    // var response = sendGetRequest('https://kj.wukongzu.com/api/Collection/category?user=' + user);
    // console.log(response, 'rrr');
    // if (response != undefined && response.data != undefined) {
    //     data = response.data;
    // }



    title.textContent = '请设置秘钥';


    
    // 不再附加“初始化”按钮到页面


    
    console.log('我运行了2222');

    // 移除手动入口：按钮已隐藏且不再绑定事件

    // 自动初始化：在目标站点上无需手动点击“初始化”
    try {
        const isAli = typeof location !== 'undefined' &&
            typeof location.hostname === 'string' &&
            location.hostname.indexOf('aliexpress.com') !== -1;

        if (isAli) {
            // 避免重复初始化
            if (!window.__ekj_auto_inited) {
                let tries = 0;
                const MAX_TRIES = 60; // 最长约 60 秒
                const checkAndInit = () => {
                    if (window.__ekj_auto_inited) return; // 已初始化
                    // 需要的容器和图片出现后再初始化，避免过早执行报错
                    const allParent = document.querySelector('#right > div:first-child > div:nth-child(1)');
                    const hasImgs = document.querySelector('a>div>div>img');
                    if (allParent && hasImgs) {
                        window.__ekj_auto_inited = true;
                        try { makeImage(); } catch (e) { console.error(e); }
                        return;
                    }
                    if (++tries < MAX_TRIES) {
                        setTimeout(checkAndInit, 1000);
                    }
                };
                // 先快速检查一次，然后进入轮询等待
                setTimeout(checkAndInit, 0);
            }

            // 监听页面动态变化（懒加载/路由切换），自动补充新元素上的控件
            if (!window.__ekj_observer_attached) {
                try {
                    const debouncedMakeImage = () => {
                        clearTimeout(window.__ekj_observeTimer);
                        window.__ekj_observeTimer = setTimeout(() => {
                            try { makeImage(); } catch (e) { console.error(e); }
                        }, 500);
                    };
                    const observer = new MutationObserver((mutations) => {
                        // 如果有新增节点或属性变动，尝试补齐
                        for (const m of mutations) {
                            if (m.addedNodes && m.addedNodes.length) { debouncedMakeImage(); break; }
                            if (m.type === 'attributes') { debouncedMakeImage(); break; }
                        }
                    });
                    observer.observe(document.body, { childList: true, subtree: true, attributes: false });
                    window.__ekj_observer_attached = true;

                    // 处理 SPA 式路由变更
                    const wrapHistory = (type) => {
                        const orig = history[type];
                        if (typeof orig === 'function') {
                            history[type] = function () {
                                const ret = orig.apply(this, arguments);
                                debouncedMakeImage();
                                return ret;
                            };
                        }
                    };
                    wrapHistory('pushState');
                    wrapHistory('replaceState');
                    window.addEventListener('popstate', debouncedMakeImage);
                } catch (e) {
                    console.error('Observer init error:', e);
                }
            }
        }
    } catch (e) {
        console.error('Auto init error:', e);
    }
}

function message(text) {
    // 创建一个临时的消息提示元素
    const message = document.createElement('div');
    message.textContent = text;
    message.style.position = 'fixed';
    message.style.top = '50%';
    message.style.left = '50%';
    message.style.transform = 'translate(-50%, -50%)';
    message.style.backgroundColor = '#333';
    message.style.color = '#fff';
    message.style.padding = '10px';
    message.style.borderRadius = '5px';
    message.style.zIndex = 999;
    document.body.appendChild(message);

    // 一段时间后移除消息提示
    setTimeout(() => {
        document.body.removeChild(message);
    }, 3000);
}
